# Assign controls

There are various tabs on this page which allow you to setup control assignments for various areas of the game. Each of these tabs contains a list of controls you can use from within the game. When playing rFactor 2 for the first time you will find that only some of the controls come with pre-assigned keys or controllers. The rest shows up as -EMPTY-. You won’t be able to use those until you manually assign a key or controller to these controls.

## Driving

### Car controls

#### Throttle  
Assign the throttle pedal.

#### Brake   
Assign the brake pedal.

#### Steer left  
#### Steer right  
While it is theoretically possible to assign *steer left* to a completely different controller than *steer right*, in practice you probably don’t want to do that. This option is mainly there for maximum configurability.

#### Shift up  
#### Shift down  
These controls let you sequentially move up or down through the gears. They are related to some other controls, for instance a setting for how to shift to reverse. Because accidentally shifting into reverse while driving is not a good idea, you may want to assign a special combination - like shift up & shift down together - for shifting into reverse. Or make sure you have to shift to neutral first before you can shift into reverse.

#### Clutch  
This control is usually assigned to the clutch pedal and is used when using a H-shifter for manually shifting gears.

#### Neutral   
This control lets you shift directly to neutral. Because it is rather dangerous when driving in the highest gears to directly shift to neutral, this control is not used very often. If you shift from sixth to neutral, for instance, and can only shift sequentially, you would have to brake first before shifting into first, or risk blowing up your engine.

#### Front handbrake
#### Handbrake
These controls operate your car’s handbrake(s). Most cars only have a rear handbrake and don’t use the front handbrake control. Handbrakes can be analog or digital. Analog handbrakes have a mechanical lever with a range. Handbrakes are mainly used in rally racing to make hairpin turns. Not recommended for normal racing!  

#### Front flap
#### Rear flap
These controls operate the DRS (Drag Reduction System) flaps. These are the wings on the car that create additional down-force to help keep the car in contact with the road. These flaps can be opened to reduce drag, for instance on straight stretches. They automatically close again when you brake so the only action you take is to open them when needed.

DRS flaps can be uses to overtake other cars, for instance, by temporarily reducing your car’s friction and drag.

Using these flaps is not without risks, however. Using them wrongly can cause your car to lose its grip on the road. It also affects your brake-length. You must also comply with any rules for using these flaps, as set by race management.

In most F1 cars there’s only a back flap. For cars that have both, both must be assigned and operated separately.

### Gearbox

#### Reverse gear
#### First gear
#### Second gear
#### Third gear
#### Fourth gear
#### Fifth gear
#### Sixth gear
#### Seventh gear
#### Eighth gear
#### Ninth gear
These controls are used when using an H-shifter which offers direct access to each gear. H-shifters are usually implemented with switches and each position of the stick pushes against one specific switch which signals which gear is requested. Most cars don’t go up to nine gears - eight is a common maximum.

Note: it is possible to combine up/down gear shifting and H-shifting which can cause strange effects while driving. Use with caution!

Some people without a H-shifter map only *Reverse gear* to a separate button, which is useful for when you go off-track or spin the car and need to get back on track quickly.

### Alternative car controls

#### Alt throttle
#### Alt brake
#### Alt steer left
#### Alt steer right
#### Alt shift up
#### Alt shift down
These slots provide alternative assignments for these common controls. This can be used, for instance, by developers who want to quickly test something in the game without having to set up their rig.

## Electronics

### Powertrain electronics

#### Increment mixture
#### Decrement mixture
These controls affect the ratio of oxygen and fuel that is fed to the engine. This changes the balance between power and fuel efficiency.
There’s often a separate mixture setting for yellow flag situations, when the car is cruising and you want to keep fuel-consumption to a minimum while power isn’t needed.

#### Increment boost
#### Decrement boost
#### Temporary boost
These controls are only available on some cars. They activate a boost function, temporarily giving the car more power. The cost of such a boost is more wear and tear on the engine and higher fuel consumption.
You need to keep the Temporary Boost key/controller pressed to maintain the boost.

#### Power Demand
This control is similar to the Boost option. It works by temporarily providing more power to the engine. Not many cars have this feature. As long as this key/controller is pressed the extra power is available.

#### Engine Brake Map Up
#### Engine Brake Map Down
Change the brake map (how much the engine slows the car when throttle is released) in cars that support it.

#### Increment regen
#### Decrement regen
Lets you choose different regeneration profiles for electric motors with adjustable regeneration levels.

#### Increment electric motor map
#### Decrement electric motor map
Lets you choose different motor profiles for electric motors with adjustable power levels.

#### Increment Push 2 Pass map
#### Decrement Push 2 Pass map
Lets you choose different push-to-pass profiles for vehicles with adjustable boost levels.

#### Activate Push 2 Pass
Activates push-to-pass (which will give you extra power for a certain amount of time) in cars that support it.

#### Check Remaining Push 2 Pass Time
Check the remaining push-to-pass time in cars that support it.

#### Arm attack mode
Attack mode is in use with Formula E cars and tracks. You can use this control to arm the attack mode before driving through the activation zone, which will then activate the attack mode.

### Driving electronics

#### Brake bias forward
#### Brake bias rearward
Brake bias is one of the settings you can adjust while driving.

Many cars have two separate brake cylinders and the brake pedal operates both. A lever or knob then lets you determine which cylinder gets more of the braking pressure when the pedal is depressed. The main reason to do so while driving is that the balance of the car can change during the race. One reason for this is the fuel that is being consumed. Another reason may be the wear on the tyres.

What you don’t want to happen is for the rear wheels to block before the front wheels do. When that happens, the rear wheels will pass the front wheels: in other words, your car spins round and you will end up facing in the wrong direction. Adjusting the brake bias during the race may help prevent this scenario from happening.

#### Stiffen front ARB
#### Soften front ARB
#### Stiffen rear ARB
#### Soften rear ARB
These controls change the stiffness of the car by adjusting the Anti-Roll Bars (ARB). This can make a subtle differences when rounding curves. These adjustments are usually set in the garage but for advanced drivers the ability to make adjustments in specific situations may help them gain small but important advantages while driving.

#### Raise track bar
#### Lower track bar
These controls work similar to the ARB. See the garage for more details.

#### Increase wedge
#### Decrease wedge
The wedge controls change the amount of cross weight in the car. In IndyCar this is known as weight jacker, and this control works when running the car in oval configuration.

### System electronics

#### Ignition
This control turns on the power in your car. The standard setting is that the power is on once you get into the car. While the ignition control is not often useful in sim racing, this control enables you to toggle between power on or power off.

#### Starter
When the ignition is on, this control starts the engine. This control is necessary when your car is not setup to have an automatic clutch and you managed to stall its engine. You then need to use this control to restart the engine.

This control can be useful for long pit stops: turning off the engine saves fuel and keeps the engine from over-heating.

#### Pit request
This control is used to announce to your crew you intend to make a pit stop. Your crew needs a certain amount of time to prepare and will send a message when they are ready for you. Announcing your intention to come in for a pit stop well in advance will give them the time to prepare and be ready when you arrive.

When you intend to make a pit stop, you use the LCD display in the bottom-right of your screen to select what you want the crew to do. In the pit menu you can cycle through different options available. The standard keys for navigating this menu are the arrow keys.

#### Speed limiter
This control limits your car’s pit-lane speed to the maximum allowed pit speed, as determined by the track you are racing on. This control only works when you haven’t turned on automatic pit speed limiting. If automatic pit limiting is off, this function lets you switch pit speed limiting on and off. Doing this manually may give you more control over your car’s speed while driving and out of the pit lane but you do run the risk of being penalised for speeding or losing time when you reach the end of the pit-lane and forget to turn the speed limiter off on time.

#### Headlights
This control toggles between car headlights on, off and if enabled into auto mode.

#### Headlights pulse
Hold this key to pulse you car's headlights on and off.

#### Wipers
This control operates the windscreen wipers. Windscreen wipers are handy when it rains, though not all cars have them. This control usually cycles between off, slow, and fast.

#### Horn
This control produces a simple horn sound. The horn is not often used in racing. Many cars don’t even have a horn as it only adds weight for a function that is not very useful.

#### Launch control
This control is only used for cars that actually do have launch control. Launch control is an algorithmically controlled mechanism to optimise the car’s start. Not many cars actually have this. If they do, you can activate this mechanism using this control.

## Assists & gameplay

### Assists

#### Steering help   
This controls the level of assisted steering, which helps with keeping the car closer to the ideal line.    

#### Opposite lock  
This control prevents you from steering against the direction the car is veering to to prevent it from spinning out of control.    

#### Braking help  
This controls the level of assistsance with breaking to help you not to go into curves too fast.    

#### Stability control  
This control cycles through different algorithms that help you keep your car stable on the road.    

#### Spin recovery  
This control turns the car back facing the right direction if it has spun all the way round.     

#### Invulnerability  
This control prevents the car from being damaged in crashes and collisions.    

#### Auto shifting   
This control is used to manage the auto-shift function of your car. It can be set to up, down or both.

Some cars had auto-up shifting built-in. Some of these cars even came with a warning to the drivers not to manually shift gears but let the automatic system take care of shifting up. These cars were carefully programmed for each track to try and produce the optimal shifting behaviour. Later this auto-shifting was banned again.   

#### Traction control  
This control helps with preventing the tyres from losing their grip on the road.   

#### Anti-lock brakes  
This control helps prevent the wheels from locking when you are braking hard.    

#### Auto pit lane  
This control determines whether the AI takes over the car when it is in the pit lane. When on, this will control the car from the moment you enter the pit lane, it will park the car, and drive it out of the pit lane up to the point where the pit speed limit ends.    

#### Auto clutch  
This control turns the auto clutch on or off. When on, it automatically engages the clutch to prevent the engine from stalling when braking or crashing.    

#### Driving Line
This control toggles the driving line options. The driving line aid has options to lead you out of the rear paddock to the pit lane, to show the direction to the pits on a scheduled stop or to just be on all the time. When enabled all the time the driving line can help you learn a new track faster. It will show you the racing line and change color dynamically between green if you need to speed up, and red if you need to slow down.

### Onboard assists

#### Traction control override
When traction control is on, this control temporarily turns it off as long as you keep this key/controller pressed in. This can be useful, for instance, when coming out of a curve. Traction control algorithms are less than perfect and tend to err on the side of caution, going a bit slower than strictly necessary. Overriding traction control wisely can give you just that bit of an edge. Especially when coming out of a curve onto a long straight stretch using this function can give you a few tenths of a second back. The downside is that you have to be a bit more cautious with accelerating, but an experienced driver should be able to outperform the traction control algorithm here.

Another use for this control is when you spun the car and find yourself facing the wrong direction. The limited arc of the car makes turning the car around quite problematic so you could step on the gas to spin the car. Traction control prohibits that.

A third scenario for using this control is at the start. You may want to win that small margin by pushing your acceleration to the very limit, i.e. pushing the wheels to the point where they almost lose grip. The cautious nature of the traction control algorithm may be just a bit too conservative for you, especially with cars that have a longer first gear.

#### Onboard TC increase    
#### Onboard TC decrease   
#### Onboard TC power cut increase
#### Onboard TC power cut decrease
#### Onboard TC slip angle increase
#### Onboard TC slip angle decrease
These controls let you increase or decrease the amount of traction control delivered by the traction control algorithm.     

#### Onboard ABS increase    
#### Onboard ABS decrease   
These controls let you increase or decrease the amount of anti-lock control delivered by the anti-lock control algorithm.      

### Gameplay

#### Driver hot swap
This control allows you to swap the driver with the passenger while driving the car. Normally a driver swap happens during a pit stop but there maybe situations where you want to swap mid-race. Using this control initiates a countdown timer before executing the actual swap.

#### Passenger select
This control allows you to select a passenger from the eligible spectators. Spectators from your team can indicate they want to become your passenger. You, as driver, need to confirm this using this control, after which the chosen spectator becomes an actual passenger you can, for instance, swap with using the control above.

#### Load vehicles
This control lets you force loading any new cars that have joined since you started the race. Normally, when new cars join the race they will be represented by a yellow ‘temp car’, a simplified object showing you there is a new car on the road, without showing you any of the details. This is done to prevent lag times during the loading of the car details, which can cause serious problems when you are trying to control your car at high speeds in the middle of the race.

These lag times will cause you car to stop moving for a moment, which is not just a problem for you, but for anybody else driving behind you. Normally, the missing cars will be loaded when you get out of your car, not while you are driving. While this control would allow you to load the missing cars at any time during the race, it is **strongly** recommended not to this while driving.

If you really want to, you could use this control while standing still during a pit stop, with enough time to spare to complete the loading before you need to drive off again.

#### Instant replay
Using this control allows you to review what happened. The time it rewinds to and the duration of the replay depend on your settings.

#### Pause
This control only works in single player mode and suspends the game until you use it again.

#### Skip formation lap
This control allows you to skip the formation lap you may have set before the actual race. It will skip to just before the end of the formation lap so you can start the race straight away.

#### Restart race
Single player mode only. This control resets the race to its beginning.

#### Screenshot
Key used for taking screenshots. They will be placed in your "rFactor 2\UserData\ScreenShots" folder. You can also set up a screenshot key in Steam: Settings → In-Game → Screenshot shortcut keys. This method will also work for taking screenshots in the rFactor 2 menus.

#### Time acceleration
Single player mode only. This control speeds up the simulation to the maximum speed your PC is capable of. Not recommended for when you are driving, but useful for when you are watching a race in single player mode and want to speed up the rest of the race.

#### Alternate ESC
This control lets you define an alternative key to function as the ESC key.

#### Triples/tires
Used with the CTRL key as modifier, this control brings up a widget to adjust the settings of your triple screen setup, if you have one.
Used with the ALT key as modifier, this key brings up a graph showing the shape of each contact patch on each tire and the temperature of each contact patch.

#### Frame rate
This control toggles the display of the frame rate on and off.

#### CPU time
This control brings up a little graph showing the amount of CPU time used by the physics engine and the speed of the GPU. The physics engine runs in time slices and the graph shows how much of each time slice it is using. The histogram shows how much of each time slice in the past few seconds was used by the physics calculations. For the GPU the graph shows how fast the graphics are being rendered.

When checking these indicators you would want the CPU to stay well below the 100% - when it reaches 100% it means there isn’t enough time per time slice to finish the required physics calculations. The GPU you want to go as fast as possible. If it is not achieving full speed it could mean there are bottlenecks preventing it from running at it fastest, such as limits on data-bus utilisation, or because you have set an upper limit to the frame rate.

The GPU graph is shown in green (Green for Graphics), the CPU is shown in purple (Purple for Physics).

## Driving cameras & seat

### Driving cameras

#### Camera change
This control cycles through all 4 different driving views, including the 3 onboard driving cameras (Cockpit, TV Cockpit, Nosecam) and the external Swingman camera.

#### Driving cameras
This control cycles between 3 different driving views available from within the car. The views are: the camera inside the car, the camera positioned on the car’s hood, and the camera positioned on the very front of the car.

#### Onboard cameras
This control cycles through all the active cameras currently on board your car. What these cameras show, and how many cameras will be available, depends on the car itself. A car can potentially have many thousands of cameras on board, although they usually won’t have much more than around ten cameras actually installed.

#### Swingman cameras
This control switches to the swingman camera. Swingman cameras are free hanging cameras used for spectacular moving shots as well as an arcade driving view. Since these are virtual cameras they can actually be in positions and move in ways that wouldn’t be possible in the real world.

#### Spectator cameras
This control cycles through all the spectator cameras placed around the track. These cameras show the view from the spectators’ perspective.

#### Tracking cameras
This control switches to the tracking broadcast cameras. Repeated presses will change the group of broadcast cameras in use. Tracking cameras are like the spectator cameras but they will lock onto and follow your car as it drives by and automatically switch between cameras to make sure your car is constantly being shown on screen as it goes round the track.

### Look around

#### Look behind
This control can be useful at times. For instance by assigning a controller on the wheel you can briefly look behind to see if there’s anyone there. But you can, of course, also use your rear view mirrors for that.

#### Look left
#### Look right
#### Look up
#### Look down
#### Look roll left
#### Look roll right
These controls move your field of vision around so you can look in directions that fall outside your normal view. Some of these can be used to create interesting effects when recording a race.

### Seat & FOV

#### Adjust seat fore
#### Adjust seat aft
#### Adjust seat up
#### Adjust seat down
These controls let you the seat position while you are in the car. Using these controls in combination with the SHIFT key will adjust the mirrors instead.
Seat and mirror settings are remembered per car.

#### Increase FOV (pitch)
#### Decrease FOV (pitch)
These controls are for people with a single monitor setup. It determines how much of the environment is visible in the monitor. What you adjust is the vertical Field Of Vision (FOV). The horizontal FOV will be adjusted accordingly. It’s not recommended to change this too often. Once you’ve found a setting you’re comfortable with, sticking with it so you get used to it will ultimately give you the best experience.

The best way to start is with a setting that most closely mimics what you would actually see from your car. With a single monitor, however, that may feel too limited, so working from there you can gradually increase your FOV until you feel you see enough of your environment for you to comfortably drive. Overdoing this, however, takes away from the realism of the experience. Ultimately, of course, this is a matter of taste.

### Swingman

#### Swingman up
#### Swingman down
#### Swingman left
#### Swingman right
#### Swingman zoom in
#### Swingman zoom out
#### Swingman reset
These controls let you manually control the currently selected swingman camera. The ‘reset’ control resets the camera back to its original position.

### Hardware

#### Reset FFB    
This control resets the force feedback mechanism, something you may need to do when it stops working completely. This reset doesn’t do anything if the FFB is working correctly.    

#### Toggle HWPlugin    
This toggles the hardware plugin system on or off. Hardware plugins modify hardware functions, such as input/output signals. Using this control turns them all on or off.    

#### Custom plugin #1     
#### Custom plugin #2     
#### Custom plugin #3     
#### Custom plugin #4     
#### Custom plugin #5     
#### Custom plugin #6     
#### Custom plugin #7     
#### Custom plugin #8     
#### Custom plugin #9     
#### Custom plugin #10     
#### Custom plugin #11     
#### Custom plugin #12     
This is a set of controls that are passed on to the plugin system. What each of these controls actually does is up to the plugin(s) responding to them.    

#### VR Center head position   
This control ensures the VR display is correctly centered in relation to your head.

#### VR Increase IPD (World Scale)   
#### VR Decrease IPD (World Scale)   
These two controls adjust the Inter-Pupillary Distance (the distance between your eyes’ pupils. This simultaneously changes the scale at which the world is displayed around you. This is comparable to the field of view settings for your monitor.

#### VR Reset IPD (World Scale)   
This control resets the IPD to its neutral setting.

## Cinematic cameras

### Cinematic cameras

#### View next vehicle
#### View previous vehicle
This control moves the focus of the camera to the next or previous car by position in the current race. Repeatedly pressing this control’s assigned key/controller cycles the camera focus past all the cars in the race.

#### View original vehicle
This control returns the focus of the camera to your own car.

#### Cam hold TV camera
Whilst pressed keeps the current TV camera activated, and prevents automatic switching.

#### Cam pause TV tracking
Whilst pressed this stops and pauses the tracking point on TV cameras. Whilst this key is pressed you can press SHIFT to set the tracked car to the one closest to the current point the camera is looking at.

#### Cam zoom in
#### Cam zoom out
#### Cam zoom reset
These controls let you zoom the current camera in and out.

### Cinematic settings

#### Tracking change blend
Tracking Change Blend will move the tracking camera focus point smoothly from one car to another when viewed vehicle changes, and they are still visible with the same camera.

#### Tracking change max difference
The maximum time difference between cars to have a blended tracking change.

#### Focused car change time delay
Time delay before changing focused car. This allows multiple presses of previous / next vehicle before moving to the car you desire.

#### Group tracking mode
When enabled tracking cameras will automatically adjust to the group centre tracking point of multiple vehicles and zoom the camera out as required. This feature is activated in race sessions only by default.

#### Group tracking range
This is the range in time that we consider cars from the currently viewed car.

#### Group tracking range lap 1
This is the range in time that we consider cars from the currently viewed car on the first lap of a race only.

#### Group tracking zoom strength
This allows the adjustment of how strong we zoom out to fit more cars on screen.

#### Group tracking zoom maximum
This is a hard limit on the maximum amount the camera can zoom out.

#### Persistent zoom
This feature allows any custom zooming in or out on the TV cameras to persist into the next camera. This can be useful for manual control on TV cameras, and acts as a scalar on top of what the TV camera already does. Additionally as the camera zooms in, any camera offsets are faded out to reduce the chance of the car being out of shot. Note however that it does not affect any offsets for group tracking.

#### Custom cameras
The game can load custom cameras from Userdata\Cameras.
For this to happen this feature must be enabled before loading content and the feature is not enabled by default.
The games trace log files output the camera filenames of each car during loading.

### Free camera

#### Freemove enable
Normally, when a camera is tracking your car, there are limits to how much you can move that camera yourself. This control gives you full control over the current camera’s movements. This mode is automatically enabled when you select Spectator Cameras. To fully use this mode set the Cam Move, Tilt and Zoom controls in addition to the Freemove and Freelook options beneath.  

#### Freemove reset
This resets the current camera to its original starting position and settings.    

#### Freelook mouse control
This toggles the forced use of mouse input to change look direction when freemove is enabled.

#### Freelens enable
Freelens is a limited version of the full feature Photo Mode which can be accessed via the UI. It allows limited lens adjustments with the keys defined below as well as enabling freemove at the same time. Note it is not possible to enable this mode when your car is moving live, and the keys beneath do not work when you are in Photomode.   

#### Freelens focus tracking
This toggles if focus locks onto the currently viewed vehicle or not.

#### Freelens focus increase
#### Freelens focus decrease
Adjust the focus distance. When tracking is enabled this is an offset from the viewed vehicle. When tracking is disable this is a static distance.

#### Freelens aperture increase
#### Freelens aperture decrease
Adjust the camera aperture factor. Lower apertures will increase blurring outside of the focus point.

#### Freelens exposure increase
#### Freelens exposure decrease
Adjust the exposure levels on the camera. This will make the image darker or brighter with in certain limits.

### Free camera movement

#### Cam move slowly
This is a modifier control, slowing the movement of the camera currently controlled by you.

#### Cam move forward
#### Cam move backward
#### Cam move left
#### Cam move right
#### Cam move up
#### Cam move down
#### Cam tilt up
#### Cam tilt down
#### Cam tilt left
#### Cam tilt right
#### Cam turn left
#### Cam turn right
These controls move the current camera and are required for Freelook mode too. If you do not assign tilt up/down and turn you can use your mouse for these movements.

## UI & chat

### HUD selection

#### Toggle mirror    
This control turns the mirror display on or off. Turning off the mirrors means your GPU has less to render, which can improve your frame rate.

#### Toggle HUD stats    
#### Toggle HUD tach    
#### Toggle HUD MFD    
These controls you can manage your Heads Up Display (HUD). This display is divided into three zones:    
- stats: showing various statistics;    
- tach: showing a number of dashboard items such as speedo, tach, revs, etc.;    
- and MFD (Mult-Function Display): showing a collection of other useful information.

As user you can fill these zones with your own preferred mix of information. The controls you assign here will turn each layer on or off.    

#### Toggle overlays    
This control toggles another layer of information.    

#### Display mode    
This control lets you scroll through the different pages of the on-screen menu.   

#### Message history   
#### Standard display   
#### Pit display   
#### Vehicle status   
#### Driving aids   
#### Extra info   
#### Race info   
#### Standings display   
#### Penalties display    
Using the *Display mode* control you can cycle through all of the displays listed above. You can also assign a different key/controller to each of the displays, so you can directly call up the display you want to access.

#### Display vehicle labels    
This control toggles on or off the display of the names of the drivers above each car.    

### UI interaction

#### Toggle Cursor    
This control removes the cursor from the screen. This is used when recording/streaming the screen and while using hardware that doesn’t automatically remove the cursor from view.

#### Pit menu up   
#### Pit menu down    
#### Pit menu increment value    
#### Pit menu decrement value    
These controls let you operate the pit stop menu that appears when requesting a pit stop.    

#### UI mouse up   
#### UI mouse down  
#### UI mouse left   
#### UI mouse right   
#### UI mouse click
This control lets you assign keys to simulate mouse actions in the User Interface.

#### Play replay
This control plays the recording from the current position.

#### Slow-motion replay
This control plays the recording at a slower speed.

#### Fast-forward replay
This control fast forwards the recording to a later point in the race.

#### Fast-rewind replay
This control fast rewinds the recording to an earlier point in the race.

#### Rewind replay
This control rewinds the recording to an earlier point in the race.

#### Stop replay
This control stops playing the recording.

### Chat

#### Realtime chat
This control opens the chat window.

#### Voice chat PTT
This function is not currently implemented.

#### Vote yes
#### Vote no
These controls enables you to vote during an online session. Voting sessions are managed by the online server you are connecting to. When a voting session is running, these controls let you cast your vote. The server settings determine what percentage of votes is required to determine the overall result.

#### Ping
This control produces a network ping event to check the network connection to the server you are connected to. The server will send a reply via the chat window.

#### Quick chat #1
#### Quick chat #2
#### Quick chat #3
#### Quick chat #4
#### Quick chat #5
#### Quick chat #6
#### Quick chat #7
#### Quick chat #8
#### Quick chat #9
The ‘quick chat’ slots are placeholders in which you can put standard responses you are likely to use during a race.